DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
	`countries_id` int(11) NOT NULL AUTO_INCREMENT,
	`countries_name` varchar(64) NOT NULL DEFAULT '',
	`countries_iso_code_2` char(2) NOT NULL DEFAULT '',
	`countries_iso_code_3` char(3) NOT NULL DEFAULT '',
	`address_format_id` int(11) NOT NULL DEFAULT '0',
	`status` int(1) DEFAULT '1',
	`is_state_mandatory` int(1) DEFAULT '0',
	PRIMARY KEY (`countries_id`),
	UNIQUE KEY `countries_iso_code_2` (`countries_iso_code_2`),
	UNIQUE KEY `countries_iso_code_3` (`countries_iso_code_3`),
	KEY `IDX_COUNTRIES_NAME` (`countries_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;

INSERT INTO `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`, `status`, `is_state_mandatory`) VALUES
	(1, 'Afghanistan', 'AF', 'AFG', 1, 1, 0),
	(2, 'Albania', 'AL', 'ALB', 1, 1, 0),
	(3, 'Algeria', 'DZ', 'DZA', 1, 1, 0),
	(4, 'American Samoa', 'AS', 'ASM', 1, 1, 0),
	(5, 'Andorra', 'AD', 'AND', 1, 1, 0),
	(6, 'Angola', 'AO', 'AGO', 1, 1, 0),
	(7, 'Anguilla', 'AI', 'AIA', 1, 1, 0),
	(8, 'Antarctica', 'AQ', 'ATA', 1, 1, 0),
	(9, 'Antigua and Barbuda', 'AG', 'ATG', 1, 1, 0),
	(10, 'Argentina', 'AR', 'ARG', 1, 1, 1),
	(11, 'Armenia', 'AM', 'ARM', 1, 1, 0),
	(12, 'Aruba', 'AW', 'ABW', 1, 1, 0),
	(13, 'Australia', 'AU', 'AUS', 1, 1, 0),
	(14, 'Austria', 'AT', 'AUT', 5, 1, 0),
	(15, 'Azerbaijan', 'AZ', 'AZE', 1, 1, 0),
	(16, 'Bahamas', 'BS', 'BHS', 1, 1, 0),
	(17, 'Bahrain', 'BH', 'BHR', 1, 1, 0),
	(18, 'Bangladesh', 'BD', 'BGD', 1, 1, 0),
	(19, 'Barbados', 'BB', 'BRB', 1, 1, 0),
	(20, 'Belarus', 'BY', 'BLR', 1, 1, 0),
	(21, 'Belgium', 'BE', 'BEL', 1, 1, 0),
	(22, 'Belize', 'BZ', 'BLZ', 1, 1, 0),
	(23, 'Benin', 'BJ', 'BEN', 1, 1, 0),
	(24, 'Bermuda', 'BM', 'BMU', 1, 1, 0),
	(25, 'Bhutan', 'BT', 'BTN', 1, 1, 0),
	(26, 'Bolivia (Plurinational State of)', 'BO', 'BOL', 1, 1, 0),
	(27, 'Bosnia and Herzegovina', 'BA', 'BIH', 1, 1, 0),
	(28, 'Botswana', 'BW', 'BWA', 1, 1, 0),
	(29, 'Bouvet Island', 'BV', 'BVT', 1, 1, 0),
	(30, 'Brazil', 'BR', 'BRA', 1, 1, 1),
	(31, 'British Indian Ocean Territory', 'IO', 'IOT', 1, 1, 0),
	(32, 'Brunei Darussalam', 'BN', 'BRN', 1, 1, 0),
	(33, 'Bulgaria', 'BG', 'BGR', 1, 1, 0),
	(34, 'Burkina Faso', 'BF', 'BFA', 1, 1, 0),
	(35, 'Burundi', 'BI', 'BDI', 1, 1, 0),
	(36, 'Cambodia', 'KH', 'KHM', 1, 1, 0),
	(37, 'Cameroon', 'CM', 'CMR', 1, 1, 0),
	(38, 'Canada', 'CA', 'CAN', 1, 1, 1),
	(39, 'Cabo Verde', 'CV', 'CPV', 1, 1, 0),
	(40, 'Cayman Islands', 'KY', 'CYM', 1, 1, 0),
	(41, 'Central African Republic', 'CF', 'CAF', 1, 1, 0),
	(42, 'Chad', 'TD', 'TCD', 1, 1, 0),
	(43, 'Chile', 'CL', 'CHL', 1, 1, 0),
	(44, 'China', 'CN', 'CHN', 1, 1, 1),
	(45, 'Christmas Island', 'CX', 'CXR', 1, 1, 0),
	(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1, 1, 0),
	(47, 'Colombia', 'CO', 'COL', 1, 1, 0),
	(48, 'Comoros', 'KM', 'COM', 1, 1, 0),
	(49, 'Congo', 'CG', 'COG', 1, 1, 0),
	(50, 'Cook Islands', 'CK', 'COK', 1, 1, 0),
	(51, 'Costa Rica', 'CR', 'CRI', 1, 1, 0),
	(52, 'Cote d''Ivoire', 'CI', 'CIV', 1, 1, 0),
	(53, 'Croatia', 'HR', 'HRV', 1, 1, 0),
	(54, 'Cuba', 'CU', 'CUB', 1, 1, 0),
	(55, 'Cyprus', 'CY', 'CYP', 1, 1, 0),
	(56, 'Czech Republic', 'CZ', 'CZE', 1, 1, 0),
	(57, 'Denmark', 'DK', 'DNK', 1, 1, 0),
	(58, 'Djibouti', 'DJ', 'DJI', 1, 1, 0),
	(59, 'Dominica', 'DM', 'DMA', 1, 1, 0),
	(60, 'Dominican Republic', 'DO', 'DOM', 1, 1, 0),
	(62, 'Ecuador', 'EC', 'ECU', 1, 1, 0),
	(63, 'Egypt', 'EG', 'EGY', 1, 1, 0),
	(64, 'El Salvador', 'SV', 'SLV', 1, 1, 0),
	(65, 'Equatorial Guinea', 'GQ', 'GNQ', 1, 1, 0),
	(66, 'Eritrea', 'ER', 'ERI', 1, 1, 0),
	(67, 'Estonia', 'EE', 'EST', 1, 1, 0),
	(68, 'Ethiopia', 'ET', 'ETH', 1, 1, 0),
	(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1, 1, 0),
	(70, 'Faroe Islands', 'FO', 'FRO', 1, 1, 0),
	(71, 'Fiji', 'FJ', 'FJI', 1, 1, 0),
	(72, 'Finland', 'FI', 'FIN', 1, 1, 0),
	(73, 'France', 'FR', 'FRA', 1, 1, 0),
	(75, 'French Guiana', 'GF', 'GUF', 1, 1, 0),
	(76, 'French Polynesia', 'PF', 'PYF', 1, 1, 0),
	(77, 'French Southern Territories', 'TF', 'ATF', 1, 1, 0),
	(78, 'Gabon', 'GA', 'GAB', 1, 1, 0),
	(79, 'Gambia', 'GM', 'GMB', 1, 1, 0),
	(80, 'Georgia', 'GE', 'GEO', 1, 1, 0),
	(81, 'Germany', 'DE', 'DEU', 5, 1, 0),
	(82, 'Ghana', 'GH', 'GHA', 1, 1, 0),
	(83, 'Gibraltar', 'GI', 'GIB', 1, 1, 0),
	(84, 'Greece', 'GR', 'GRC', 1, 1, 0),
	(85, 'Greenland', 'GL', 'GRL', 1, 1, 0),
	(86, 'Grenada', 'GD', 'GRD', 1, 1, 0),
	(87, 'Guadeloupe', 'GP', 'GLP', 1, 1, 0),
	(88, 'Guam', 'GU', 'GUM', 1, 1, 0),
	(89, 'Guatemala', 'GT', 'GTM', 1, 1, 0),
	(90, 'Guinea', 'GN', 'GIN', 1, 1, 0),
	(91, 'Guinea-Bissau', 'GW', 'GNB', 1, 1, 0),
	(92, 'Guyana', 'GY', 'GUY', 1, 1, 0),
	(93, 'Haiti', 'HT', 'HTI', 1, 1, 0),
	(94, 'Heard Island and McDonald Islands', 'HM', 'HMD', 1, 1, 0),
	(95, 'Honduras', 'HN', 'HND', 1, 1, 0),
	(96, 'Hong Kong', 'HK', 'HKG', 1, 1, 0),
	(97, 'Hungary', 'HU', 'HUN', 1, 1, 0),
	(98, 'Iceland', 'IS', 'ISL', 1, 1, 0),
	(99, 'India', 'IN', 'IND', 1, 1, 1),
	(100, 'Indonesia', 'ID', 'IDN', 1, 1, 1),
	(101, 'Iran (Islamic Republic of)', 'IR', 'IRN', 1, 1, 0),
	(102, 'Iraq', 'IQ', 'IRQ', 1, 1, 0),
	(103, 'Ireland', 'IE', 'IRL', 1, 1, 0),
	(104, 'Israel', 'IL', 'ISR', 1, 1, 0),
	(105, 'Italy', 'IT', 'ITA', 1, 1, 0),
	(106, 'Jamaica', 'JM', 'JAM', 1, 1, 0),
	(107, 'Japan', 'JP', 'JPN', 1, 1, 1),
	(108, 'Jordan', 'JO', 'JOR', 1, 1, 0),
	(109, 'Kazakhstan', 'KZ', 'KAZ', 1, 1, 0),
	(110, 'Kenya', 'KE', 'KEN', 1, 1, 0),
	(111, 'Kiribati', 'KI', 'KIR', 1, 1, 0),
	(112, 'Korea (the Democratic People''s Republic of)', 'KP', 'PRK', 1, 1, 0),
	(113, 'Korea (the Republic of)', 'KR', 'KOR', 1, 1, 0),
	(114, 'Kuwait', 'KW', 'KWT', 1, 1, 0),
	(115, 'Kyrgyzstan', 'KG', 'KGZ', 1, 1, 0),
	(116, 'Lao People''s Democratic Republic', 'LA', 'LAO', 1, 1, 0),
	(117, 'Latvia', 'LV', 'LVA', 1, 1, 0),
	(118, 'Lebanon', 'LB', 'LBN', 1, 1, 0),
	(119, 'Lesotho', 'LS', 'LSO', 1, 1, 0),
	(120, 'Liberia', 'LR', 'LBR', 1, 1, 0),
	(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 1, 1, 0),
	(122, 'Liechtenstein', 'LI', 'LIE', 1, 1, 0),
	(123, 'Lithuania', 'LT', 'LTU', 1, 1, 0),
	(124, 'Luxembourg', 'LU', 'LUX', 1, 1, 0),
	(125, 'Macao', 'MO', 'MAC', 1, 1, 0),
	(126, 'Macedonia (the former Yugoslav Republic of)', 'MK', 'MKD', 1, 1, 0),
	(127, 'Madagascar', 'MG', 'MDG', 1, 1, 0),
	(128, 'Malawi', 'MW', 'MWI', 1, 1, 0),
	(129, 'Malaysia', 'MY', 'MYS', 1, 1, 0),
	(130, 'Maldives', 'MV', 'MDV', 1, 1, 0),
	(131, 'Mali', 'ML', 'MLI', 1, 1, 0),
	(132, 'Malta', 'MT', 'MLT', 1, 1, 0),
	(133, 'Marshall Islands', 'MH', 'MHL', 1, 1, 0),
	(134, 'Martinique', 'MQ', 'MTQ', 1, 1, 0),
	(135, 'Mauritania', 'MR', 'MRT', 1, 1, 0),
	(136, 'Mauritius', 'MU', 'MUS', 1, 1, 0),
	(137, 'Mayotte', 'YT', 'MYT', 1, 1, 0),
	(138, 'Mexico', 'MX', 'MEX', 1, 1, 1),
	(139, 'Micronesia (Federated States of)', 'FM', 'FSM', 1, 1, 0),
	(140, 'Moldova (the Republic of)', 'MD', 'MDA', 1, 1, 0),
	(141, 'Monaco', 'MC', 'MCO', 1, 1, 0),
	(142, 'Mongolia', 'MN', 'MNG', 1, 1, 0),
	(143, 'Montserrat', 'MS', 'MSR', 1, 1, 0),
	(144, 'Morocco', 'MA', 'MAR', 1, 1, 0),
	(145, 'Mozambique', 'MZ', 'MOZ', 1, 1, 0),
	(146, 'Myanmar', 'MM', 'MMR', 1, 1, 0),
	(147, 'Namibia', 'NA', 'NAM', 1, 1, 0),
	(148, 'Nauru', 'NR', 'NRU', 1, 1, 0),
	(149, 'Nepal', 'NP', 'NPL', 1, 1, 0),
	(150, 'Netherlands', 'NL', 'NLD', 1, 1, 0),
	(152, 'New Caledonia', 'NC', 'NCL', 1, 1, 0),
	(153, 'New Zealand', 'NZ', 'NZL', 1, 1, 0),
	(154, 'Nicaragua', 'NI', 'NIC', 1, 1, 0),
	(155, 'Niger', 'NE', 'NER', 1, 1, 0),
	(156, 'Nigeria', 'NG', 'NGA', 1, 1, 0),
	(157, 'Niue', 'NU', 'NIU', 1, 1, 0),
	(158, 'Norfolk Island', 'NF', 'NFK', 1, 1, 0),
	(159, 'Northern Mariana Islands', 'MP', 'MNP', 1, 1, 0),
	(160, 'Norway', 'NO', 'NOR', 1, 1, 0),
	(161, 'Oman', 'OM', 'OMN', 1, 1, 0),
	(162, 'Pakistan', 'PK', 'PAK', 1, 1, 0),
	(163, 'Palau', 'PW', 'PLW', 1, 1, 0),
	(164, 'Panama', 'PA', 'PAN', 1, 1, 0),
	(165, 'Papua New Guinea', 'PG', 'PNG', 1, 1, 0),
	(166, 'Paraguay', 'PY', 'PRY', 1, 1, 0),
	(167, 'Peru', 'PE', 'PER', 1, 1, 0),
	(168, 'Philippines', 'PH', 'PHL', 1, 1, 0),
	(169, 'Pitcairn', 'PN', 'PCN', 1, 1, 0),
	(170, 'Poland', 'PL', 'POL', 1, 1, 0),
	(171, 'Portugal', 'PT', 'PRT', 1, 1, 0),
	(172, 'Puerto Rico', 'PR', 'PRI', 1, 1, 0),
	(173, 'Qatar', 'QA', 'QAT', 1, 1, 0),
	(174, 'Réunion', 'RE', 'REU', 1, 1, 0),
	(175, 'Romania', 'RO', 'ROM', 1, 1, 0),
	(176, 'Russian Federation', 'RU', 'RUS', 1, 1, 0),
	(177, 'Rwanda', 'RW', 'RWA', 1, 1, 0),
	(178, 'Saint Kitts and Nevis', 'KN', 'KNA', 1, 1, 0),
	(179, 'Saint Lucia', 'LC', 'LCA', 1, 1, 0),
	(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1, 1, 0),
	(181, 'Samoa', 'WS', 'WSM', 1, 1, 0),
	(182, 'San Marino', 'SM', 'SMR', 1, 1, 0),
	(183, 'Sao Tome and Principe', 'ST', 'STP', 1, 1, 0),
	(184, 'Saudi Arabia', 'SA', 'SAU', 1, 1, 0),
	(185, 'Senegal', 'SN', 'SEN', 1, 1, 0),
	(186, 'Seychelles', 'SC', 'SYC', 1, 1, 0),
	(187, 'Sierra Leone', 'SL', 'SLE', 1, 1, 0),
	(188, 'Singapore', 'SG', 'SGP', 4, 1, 0),
	(189, 'Slovakia (Slovak Republic)', 'SK', 'SVK', 1, 1, 0),
	(190, 'Slovenia', 'SI', 'SVN', 1, 1, 0),
	(191, 'Solomon Islands', 'SB', 'SLB', 1, 1, 0),
	(192, 'Somalia', 'SO', 'SOM', 1, 1, 0),
	(193, 'South Africa', 'ZA', 'ZAF', 1, 1, 0),
	(194, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', 1, 1, 0),
	(195, 'Spain', 'ES', 'ESP', 3, 1, 0),
	(196, 'Sri Lanka', 'LK', 'LKA', 1, 1, 0),
	(197, 'Saint Helena, Ascension and Tristan da Cunha', 'SH', 'SHN', 1, 1, 0),
	(198, 'St. Pierre and Miquelon', 'PM', 'SPM', 1, 1, 0),
	(199, 'Sudan', 'SD', 'SDN', 1, 1, 0),
	(200, 'Suriname', 'SR', 'SUR', 1, 1, 0),
	(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1, 1, 0),
	(202, 'Swaziland', 'SZ', 'SWZ', 1, 1, 0),
	(203, 'Sweden', 'SE', 'SWE', 1, 1, 0),
	(204, 'Switzerland', 'CH', 'CHE', 5, 1, 0),
	(205, 'Syrian Arab Republic', 'SY', 'SYR', 1, 1, 0),
	(206, 'Taiwan (Province of China)', 'TW', 'TWN', 1, 1, 0),
	(207, 'Tajikistan', 'TJ', 'TJK', 1, 1, 0),
	(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 1, 1, 0),
	(209, 'Thailand', 'TH', 'THA', 1, 1, 1),
	(210, 'Togo', 'TG', 'TGO', 1, 1, 0),
	(211, 'Tokelau', 'TK', 'TKL', 1, 1, 0),
	(212, 'Tonga', 'TO', 'TON', 1, 1, 0),
	(213, 'Trinidad and Tobago', 'TT', 'TTO', 1, 1, 0),
	(214, 'Tunisia', 'TN', 'TUN', 1, 1, 0),
	(215, 'Turkey', 'TR', 'TUR', 1, 1, 0),
	(216, 'Turkmenistan', 'TM', 'TKM', 1, 1, 0),
	(217, 'Turks and Caicos Islands', 'TC', 'TCA', 1, 1, 0),
	(218, 'Tuvalu', 'TV', 'TUV', 1, 1, 0),
	(219, 'Uganda', 'UG', 'UGA', 1, 1, 0),
	(220, 'Ukraine', 'UA', 'UKR', 1, 1, 0),
	(221, 'United Arab Emirates', 'AE', 'ARE', 1, 1, 0),
	(222, 'United Kingdom', 'GB', 'GBR', 1, 1, 0),
	(223, 'United States of America', 'US', 'USA', 2, 1, 1),
	(224, 'United States Minor Outlying Islands', 'UM', 'UMI', 1, 1, 0),
	(225, 'Uruguay', 'UY', 'URY', 1, 1, 0),
	(226, 'Uzbekistan', 'UZ', 'UZB', 1, 1, 0),
	(227, 'Vanuatu', 'VU', 'VUT', 1, 1, 0),
	(228, 'Vatican City State (Holy See)', 'VA', 'VAT', 1, 1, 0),
	(229, 'Venezuela (Bolivarian Republic of)', 'VE', 'VEN', 1, 1, 0),
	(230, 'Viet Nam', 'VN', 'VNM', 1, 1, 0),
	(231, 'Virgin Islands (British)', 'VG', 'VGB', 1, 1, 0),
	(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1, 1, 0),
	(233, 'Wallis and Futuna Islands', 'WF', 'WLF', 1, 1, 0),
	(234, 'Western Sahara', 'EH', 'ESH', 1, 1, 0),
	(235, 'Yemen', 'YE', 'YEM', 1, 1, 0),
	(238, 'Zambia', 'ZM', 'ZMB', 1, 1, 0),
	(239, 'Zimbabwe', 'ZW', 'ZWE', 1, 1, 0),
	(240, 'Serbia', 'RS', 'SRB', 1, 1, 0),
	(241, 'Montenegro', 'ME', 'MNE', 1, 1, 0),
	(242, 'Åland Islands', 'AX', 'ALA', 1, 1, 0),
	(243, 'Saint Barthélemy', 'BL', 'BLM', 1, 1, 0),
	(244, 'Bonaire, Sint Eustatius and Saba', 'BQ', 'BES', 1, 1, 0),
	(245, 'Congo (the Democratic Republic of the)', 'CD', 'COD', 1, 1, 0),
	(246, 'Curaçao', 'CW', 'CUW', 1, 1, 0),
	(247, 'Guernsey', 'GG', 'GGY', 1, 1, 0),
	(248, 'Isle of Man', 'IM', 'IMN', 1, 1, 0),
	(249, 'Jersey', 'JE', 'JEY', 1, 1, 0),
	(251, 'Saint Martin (French part)', 'MF', 'MAF', 1, 1, 0),
	(252, 'Palestine, State of', 'PS', 'PSE', 1, 1, 0),
	(253, 'South Sudan', 'SS', 'SSD', 1, 1, 0),
	(254, 'Sint Maarten (Dutch part)', 'SX', 'SXM', 1, 1, 0),
	(255, 'Timor-Leste', 'TL', 'TLS', 1, 1, 0);